/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Font3D;
import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3D;
import com.roguewave.chart.core.v2_1.graphics.Markings3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3DDrawable;
import com.roguewave.chart.core.v2_1.graphics.ScaledFont3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.Bar;
import com.roguewave.chart.standard.v2_1.parts.CompoundDrawable;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class Platform
implements Customizer {
    private static final double defaultBasePad = 0.25;
    private static final double defaultBaseHeight = 0.5;
    private static final Color defaultPlatformColor = Color.lightGray;
    private static final Color defaultPlatformLabelColor = Color.black;
    private static final Font3D defaultFont3D = new Font3D();
    boolean isMultiRow_;

    public Platform() {
        this(true);
    }

    public Platform(boolean isMultiRow) {
        this.isMultiRow_ = isMultiRow;
    }

    public Drawable getDrawable(ChartProperties properties, DataModel data) {
        int rows = this.isMultiRow_ ? data.getRowCount() : 1;
        double platformPad = properties.getProperty("BasePad", 0.25);
        double platformHeight = properties.getProperty("PlatformHeight", 0.5);
        Color baseColor = (Color)properties.getProperty("PlatformColor", defaultPlatformColor);
        Color labelColor = (Color)properties.getProperty("PlatformLabelColor", defaultPlatformLabelColor);
        int columns = data.getColumnCount();
        double platformFrontZ = (double)(-rows) / 2.0 - platformPad;
        double platformBackZ = (double)rows / 2.0 + platformPad;
        Vector<Drawable> drawables = new Vector<Drawable>();
        Polygon3D[] polygons = new Bar(new Point3D(0.0, -platformHeight, 0.0), (double)columns, (double)rows + platformPad * (double)2, platformHeight, baseColor).polygons();
        for (int i = 0; i < polygons.length; ++i) {
            drawables.addElement(new Polygon3DDrawable(polygons[i]));
        }
        double labelHeight = 0.8 * platformHeight;
        ScaledFont3D scaledFont = new ScaledFont3D(defaultFont3D, labelHeight, true);
        double fontPad = 0.1;
        double labelX = -((double)columns) / 2.0;
        double labelY = -platformHeight - scaledFont.getMaxDescent() + 0.1 * platformHeight;
        Point3D[] textPlane = new Point3D[]{new Point3D(0.0, 0.0, platformFrontZ), new Point3D(0.0, 1.0, platformFrontZ), new Point3D(1.0, 0.0, platformFrontZ)};
        double xScale = 0.5;
        Transform3D scaleX = Transform3D.scale(xScale, 1.0, 1.0);
        Vector<Line3D> topGridLines = new Vector<Line3D>();
        for (int i = 0; i < columns; ++i) {
            String label = data.getColumnLabel(i);
            double stringWidth = scaledFont.stringWidth(label) * xScale;
            Transform3D strans = scaleX;
            if (stringWidth > 0.9) {
                double scale = 1.0 / stringWidth * xScale * 0.9;
                strans = Transform3D.scale(scale, 1.0, 1.0);
                stringWidth = scaledFont.stringWidth(label) * scale;
            }
            Point3D labelOrigin = new Point3D(labelX + 0.5 - stringWidth / 2.0, labelY, platformFrontZ);
            Vector lines = scaledFont.stringLines(label, labelOrigin, strans);
            lines.addElement(new Line3D(new Point3D(labelX + 1.0, 0.0, platformFrontZ), new Point3D(labelX + 1.0, -platformHeight, platformFrontZ)));
            Markings3D marks = new Markings3D(textPlane, lines);
            drawables.addElement(new Markings3DDrawable(marks, labelColor));
            Line3D topLine = new Line3D(new Point3D(labelX + 1.0, 0.0, platformFrontZ), new Point3D(labelX + 1.0, 0.0, platformBackZ));
            topGridLines.addElement(topLine);
            labelX += 1.0;
        }
        Transform3D fontTrans = new Transform3D(Transform3D.rotateY(90.0), Transform3D.scale(xScale, 1.0, 1.0));
        labelX = (double)columns / 2.0;
        textPlane = new Point3D[]{new Point3D(labelX, 0.0, 0.0), new Point3D(labelX, 1.0, 0.0), new Point3D(labelX, 0.0, 1.0)};
        if (rows == 1) {
            String label = data.getColumnVariableName();
            double stringWidth = scaledFont.stringWidth(label) * xScale;
            Transform3D strans = fontTrans;
            if (stringWidth > 0.9) {
                double scale = 1.0 / stringWidth * xScale * 0.9;
                strans = new Transform3D(Transform3D.rotateY(90.0), Transform3D.scale(scale, 1.0, 1.0));
                stringWidth = scaledFont.stringWidth(label) * scale;
            }
            Point3D labelOrigin = new Point3D(labelX, labelY, -stringWidth / (double)2);
            Vector lines = scaledFont.stringLines(label, labelOrigin, strans);
            Markings3D marks = new Markings3D(textPlane, lines);
            drawables.addElement(new Markings3DDrawable(marks, labelColor));
        } else {
            double cellZ = platformFrontZ + platformPad;
            for (int i = 0; i < rows; ++i) {
                String label = data.getRowLabel(i);
                double stringWidth = scaledFont.stringWidth(label) * xScale;
                Transform3D strans = fontTrans;
                if (stringWidth > 0.9) {
                    double scale = 1.0 / stringWidth * xScale * 0.9;
                    strans = new Transform3D(Transform3D.rotateY(90.0), Transform3D.scale(scale, 1.0, 1.0));
                    stringWidth = scaledFont.stringWidth(label) * scale;
                }
                Point3D labelOrigin = new Point3D(labelX, labelY, cellZ + 0.5 - stringWidth / (double)2);
                Vector lines = scaledFont.stringLines(label, labelOrigin, strans);
                if (i != 0) {
                    lines.addElement(new Line3D(new Point3D(labelX, 0.0, cellZ), new Point3D(labelX, -platformHeight, cellZ)));
                    topGridLines.addElement(new Line3D(new Point3D(-labelX, 0.0, cellZ), new Point3D(labelX, 0.0, cellZ)));
                }
                Markings3D marks = new Markings3D(textPlane, lines);
                drawables.addElement(new Markings3DDrawable(marks, labelColor));
                cellZ += 1.0;
            }
        }
        Point3D[] testPoints = new Point3D[]{new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 0.0, 1.0), new Point3D(1.0, 0.0, 0.0)};
        Markings3DDrawable topGrid = new Markings3DDrawable(new Markings3D(testPoints, topGridLines), Color.black);
        drawables.addElement(topGrid);
        return new CompoundDrawable(drawables);
    }

    public Customizer getPlatform() {
        return this;
    }

    public boolean getIsMultiRow() {
        return this.isMultiRow_;
    }

    public void setIsMultiRow(boolean isMultiRow) {
        this.isMultiRow_ = isMultiRow;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }
}

